<?php
require_once __DIR__ . '/../../config.php';
session_start();
if (empty($_SESSION['admin'])) { http_response_code(403); exit('Forbidden'); }

$old = $_POST['old'] ?? '';
$new = $_POST['new'] ?? '';
$confirm = $_POST['confirm'] ?? '';

if ($new === '' || $new !== $confirm) { http_response_code(400); exit('Konfirmasi tidak cocok'); }

$stmt = $pdo->prepare("SELECT * FROM admin_users WHERE admin_username=? LIMIT 1");
$stmt->execute([$_SESSION['admin']]);
$row = $stmt->fetch();
if (!$row || !hash_equals($row['admin_password_hash'], hash('sha256',$old))) {
  http_response_code(400); exit('Password lama salah');
}

$upd = $pdo->prepare("UPDATE admin_users SET admin_password_hash=? WHERE id=?");
$upd->execute([hash('sha256',$new), $row['id']]);

header('Location: ../password.php');