<?php include 'header.php'; ?>
<section class="content">
  <div class="container-fluid">
    <div class="mb-3">
      <button class="btn btn-success" data-toggle="modal" data-target="#modalAdd">Tambah Blokir</button>
    </div>
    <div class="card">
      <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
          <thead><tr><th>No.</th><th>ID Device</th><th>Mcaddress</th><th>IP Address</th><th>Aksi</th></tr></thead>
          <tbody>
          <?php
          $rows = $pdo->query("SELECT * FROM blocks ORDER BY id DESC")->fetchAll();
          $i=1; foreach ($rows as $r):
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= htmlspecialchars($r['device_id'] ?: '-') ?></td>
              <td><?= htmlspecialchars($r['mac_address'] ?: '-') ?></td>
              <td><?= htmlspecialchars($r['ip_address'] ?: '-') ?></td>
              <td><button class="btn btn-sm btn-danger" onclick="delBl(<?=intval($r['id'])?>)">Hapus</button></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="modalAdd">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="api/block_create.php">
      <div class="modal-header"><h5 class="modal-title">Tambah Blokir</h5><button type="button" class="close" data-dismiss="modal">&times;</button></div>
      <div class="modal-body">
        <div class="form-group"><label>ID Device</label><input name="device_id" class="form-control"></div>
        <div class="form-group"><label>Mcaddress</label><input name="mac_address" class="form-control"></div>
        <div class="form-group"><label>IP Address</label><input name="ip_address" class="form-control"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Batal</button>
        <button class="btn btn-primary">Simpan</button>
      </div>
    </form>
  </div>
</div>

<script>
function delBl(id){
  if(!confirm('Hapus blokir?')) return;
  fetch('api/block_delete.php',{method:'POST',body:new URLSearchParams({id:id})}).then(r=>r.text()).then(t=>location.reload());
}
</script>
<?php include 'footer.php'; ?>