<?php include 'header.php'; ?>
<section class="content">
  <div class="container-fluid">
    <div class="mb-3">
      <button class="btn btn-success" data-toggle="modal" data-target="#modalAdd">Tambah User</button>
    </div>
    <div class="card">
      <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
          <thead><tr>
            <th>ID</th><th>Flag</th><th>LogSes</th><th>Username</th><th>Expiredate</th><th>Playlist</th>
            <th>Add Device</th><th>Sisa Limit</th><th>ID Device</th><th>Mcaddress</th><th>Useragent</th><th>IP Address</th><th>Aksi</th>
          </tr></thead>
          <tbody>
          <?php
          $rows = $pdo->query("
            SELECT u.*,
              (u.device_limit - IFNULL((SELECT COUNT(*) FROM devices d WHERE d.user_id=u.id),0)) AS sisa_limit
            FROM users u ORDER BY u.id DESC
          ")->fetchAll();
          foreach ($rows as $r):
            $isExpired = (new DateTime($r['expiredate'])) < (new DateTime('today'));
            $color = $isExpired ? 'red' : 'lime';
            $devs = $pdo->prepare("SELECT GROUP_CONCAT(device_id SEPARATOR ',') AS dids, GROUP_CONCAT(mac_address SEPARATOR ',') AS macs, GROUP_CONCAT(DISTINCT user_agent SEPARATOR ' | ') AS uas, GROUP_CONCAT(DISTINCT ip_address SEPARATOR ',') AS ips FROM devices WHERE user_id=?");
            $devs->execute([$r['id']]);
            $d = $devs->fetch() ?: ['dids'=>'','macs'=>'','uas'=>'','ips'=>''];
          ?>
            <tr>
              <td><?=htmlspecialchars($r['id'])?></td>
              <td><span class="badge <?=($r['flag']=='sukses'?'badge-success':($r['flag']=='expiredate'?'badge-danger':'badge-secondary'))?>"><?=htmlspecialchars($r['flag'])?></span></td>
              <td><?=htmlspecialchars($r['logses'])?></td>
              <td><span style="color:<?=$color?>;font-weight:600"><?=htmlspecialchars($r['username'])?></span></td>
              <td><?= (new DateTime($r['expiredate']))->format('d/m/Y') ?></td>
              <td><?=htmlspecialchars($r['playlist'])?></td>
              <td><?=htmlspecialchars($r['device_limit'])?></td>
              <td><?=htmlspecialchars($r['sisa_limit'])?></td>
              <td><?=htmlspecialchars($d['dids'] ?: '-')?></td>
              <td><?=htmlspecialchars($d['macs'] ?: '-')?></td>
              <td style="max-width:240px;white-space:normal"><?=htmlspecialchars($d['uas'] ?: '-')?></td>
              <td><?=htmlspecialchars($d['ips'] ?: '-')?></td>
              <td>
                <button class="btn btn-sm btn-primary" onclick="editUser(<?=intval($r['id'])?>)">Edit</button>
                <button class="btn btn-sm btn-danger" onclick="delUser(<?=intval($r['id'])?>)">Hapus</button>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</section>

<!-- Modal Add -->
<div class="modal fade" id="modalAdd">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="api/user_create.php">
      <div class="modal-header"><h5 class="modal-title">Tambah User</h5><button type="button" class="close" data-dismiss="modal">&times;</button></div>
      <div class="modal-body">
        <div class="form-group">
          <label>Flag</label>
          <input class="form-control" value="start" readonly>
        </div>
        <div class="form-group">
          <label>Logses</label>
          <input class="form-control" value="0" readonly>
        </div>
        <div class="form-group">
          <label>Username</label>
          <input name="username" class="form-control" minlength="5" maxlength="10" pattern="[A-Za-z][A-Za-z0-9]{4,9}" required>
        </div>
        <div class="form-group">
          <label>Expiredate (dd/mm/yyyy)</label>
          <input name="expiredate" class="form-control" placeholder="dd/mm/yyyy" required>
        </div>
        <div class="form-group">
          <label>Playlist</label>
          <select name="playlist" class="custom-select" required>
            <?php
            $pls = $pdo->query("SELECT name FROM playlists ORDER BY id DESC")->fetchAll();
            foreach ($pls as $p) echo '<option value="'.htmlspecialchars($p['name']).'">'.htmlspecialchars($p['name']).'</option>';
            ?>
          </select>
        </div>
        <div class="form-group">
          <label>Add Device</label>
          <input type="number" name="device_limit" class="form-control" value="1" min="1" max="50" required>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Batal</button>
        <button class="btn btn-primary">Simpan</button>
      </div>
    </form>
  </div>
</div>

<script>
function editUser(id){ alert('Edit endpoint belum dibuat di demo ini. Silakan tambah via API user_update.php'); }
function delUser(id){
  if(!confirm('Hapus user?')) return;
  fetch('api/user_delete.php',{method:'POST',body:new URLSearchParams({id:id})}).then(r=>r.text()).then(t=>location.reload());
}
</script>
<?php include 'footer.php'; ?>