<?php
require_once __DIR__ . '/config.php';

function log_error($info, $username = null) {
  global $pdo;
  $stmt = $pdo->prepare("INSERT INTO error_logs (info, username, ip_address) VALUES (?,?,?)");
  $stmt->execute([$info, $username, client_ip()]);
}

function valid_username($u) {
  if (!preg_match('/^[a-zA-Z][a-zA-Z0-9]{4,9}$/', $u)) return false;
  return true;
}

function parse_date_dmy($s) {
  $dt = DateTime::createFromFormat('d/m/Y', $s);
  return $dt ? $dt->format('Y-m-d') : null;
}

function is_blocked($deviceId, $mac, $ip) {
  global $pdo;
  $q = "SELECT 1 FROM blocks WHERE 
          (device_id IS NOT NULL AND device_id <> '' AND device_id = ?) OR
          (mac_address IS NOT NULL AND mac_address <> '' AND mac_address = ?) OR
          (ip_address IS NOT NULL AND ip_address <> '' AND ip_address = ?)
        LIMIT 1";
  $stmt = $pdo->prepare($q);
  $stmt->execute([$deviceId ?: '', $mac ?: '', $ip ?: '']);
  return (bool)$stmt->fetchColumn();
}

function touch_device($userId, $deviceId, $mac, $ua, $ip) {
  global $pdo;
  $stmt = $pdo->prepare("SELECT id FROM devices WHERE user_id=? AND device_id <=> ?");
  $stmt->execute([$userId, $deviceId]);
  $row = $stmt->fetch();
  if (!$row) {
    $used = $pdo->prepare("SELECT COUNT(*) FROM devices WHERE user_id=?");
    $used->execute([$userId]);
    $usedCnt = (int)$used->fetchColumn();

    $limit = $pdo->prepare("SELECT device_limit FROM users WHERE id=?");
    $limit->execute([$userId]);
    $limitCnt = (int)$limit->fetchColumn();

    if ($usedCnt >= $limitCnt) {
      return [false, "Device limit exceeded ($usedCnt/$limitCnt)"];
    }

    $ins = $pdo->prepare("INSERT INTO devices (user_id, device_id, mac_address, user_agent, ip_address) VALUES (?,?,?,?,?)");
    $ins->execute([$userId, $deviceId, $mac, $ua, $ip]);
  }
  return [true, null];
}

function ensure_hash_for_url($originUrl, $userId = null, $playlistName = null) {
  global $pdo, $tokenTTLSeconds, $hashSalt;
  $stmt = $pdo->prepare("SELECT hash_code, expires_at FROM token_map WHERE origin_url=? AND user_id <=> ? AND playlist_name <=> ? ORDER BY id DESC LIMIT 1");
  $stmt->execute([$originUrl, $userId, $playlistName]);
  $row = $stmt->fetch();

  $now = time();
  if ($row) {
    $exp = strtotime($row['expires_at']);
    if ($exp > $now + 300) {
      return $row['hash_code'];
    }
  }

  $seed = $originUrl . '|' . $userId . '|' . $playlistName . '|' . $now . '|' . bin2hex(random_bytes(16));
  $hash = sha1($seed . $hashSalt);
  $expires = date('Y-m-d H:i:s', $now + $tokenTTLSeconds);

  $ins = $pdo->prepare("INSERT INTO token_map (hash_code, origin_url, user_id, playlist_name, expires_at) VALUES (?,?,?,?,?)");
  $ins->execute([$hash, $originUrl, $userId, $playlistName, $expires]);

  return $hash;
}

function rewrite_playlist_urls($content, $userId=null, $playlistName=null) {
  global $vipBase;
  return preg_replace_callback('#https?://[^\s"\']+#i', function($m) use ($userId,$playlistName,$vipBase) {
    $origin = $m[0];
    $hash = ensure_hash_for_url($origin, $userId, $playlistName);
    return $vipBase . '/t/' . $hash;
  }, $content);
}