<?php
require_once __DIR__ . '/functions.php';

header('Content-Type: application/vnd.apple.mpegurl');

$username = isset($_GET['user']) ? trim($_GET['user']) : '';
if (!$username || !valid_username($username)) {
  log_error('Invalid username param', $username);
  http_response_code(400);
  echo "# Error: invalid username\n";
  exit;
}

$stmt = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
$stmt->execute([$username]);
$user = $stmt->fetch();

if (!$user) {
  log_error('Username not found', $username);
  echo "# Error: user not found\n";
  exit;
}

$today = new DateTime('today');
$exp   = new DateTime($user['expiredate']);

if ($today > $exp) {
  if ($user['flag'] !== 'expiredate') {
    $pdo->prepare("UPDATE users SET flag='expiredate' WHERE id=?")->execute([$user['id']]);
  }
  echo "# Error: expired\n";
  exit;
}

$deviceId = $_GET['device'] ?? ($_SERVER['HTTP_X_DEVICE_ID'] ?? null);
$mac      = $_GET['mac'] ?? ($_SERVER['HTTP_X_MAC_ADDRESS'] ?? null);
$ua       = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ip       = client_ip();

if (is_blocked($deviceId, $mac, $ip)) {
  $pdo->prepare("UPDATE users SET flag='gagal' WHERE id=?")->execute([$user['id']]);
  log_error('Blocked device tried to access', $username);
  echo "# Error: device blocked\n";
  exit;
}

list($ok, $reason) = touch_device($user['id'], $deviceId, $mac, $ua, $ip);
if (!$ok) {
  log_error('Device limit exceeded: '.$reason, $username);
  echo "# Error: device limit exceeded\n";
  exit;
}

$pdo->prepare("UPDATE users SET logses = logses + 1, flag='sukses' WHERE id=?")->execute([$user['id']]);

$playlistName = $user['playlist'];
$playlistFile = __DIR__ . '/playlist/' . $playlistName . '.php';
if (!is_file($playlistFile)) {
  log_error("Playlist file missing: $playlistName.php", $username);
  echo "# Error: playlist not found\n";
  exit;
}

ob_start();
require $playlistFile;
$content = ob_get_clean();
if (!is_string($content) || $content === '') {
  $content = "#EXTM3U\n";
}

$out = rewrite_playlist_urls($content, $user['id'], $playlistName);
echo $out;