<?php
require_once __DIR__ . '/functions.php';

$code = $_GET['code'] ?? '';
if (!preg_match('/^[A-Fa-f0-9]{40}$/', $code)) {
    http_response_code(400);
    echo "Bad code";
    exit;
}

$cacheDir = __DIR__ . '/cache';
if (!is_dir($cacheDir)) mkdir($cacheDir, 0755, true);
$cacheFile = "$cacheDir/$code.json";
$cacheTTL = 60 * 60;        // cache lokal 1 jam
$cacheMaxAge = 24 * 60 * 60; // hapus file cache > 24 jam

//  Pembersihan file cache lama otomatis
foreach (glob("$cacheDir/*.json") as $f) {
    if (filemtime($f) < (time() - $cacheMaxAge)) {
        @unlink($f);
    }
}

// ambil dari cache lokal (cepat)
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTTL) {
    $row = json_decode(file_get_contents($cacheFile), true);
} else {
    //  Ambil dari database (jika belum ada cache)
    $stmt = $pdo->prepare("SELECT origin_url, user_id, playlist_name, expires_at FROM token_map WHERE hash_code=? LIMIT 1");
    $stmt->execute([$code]);
    $row = $stmt->fetch();

    if (!$row) {
        http_response_code(404);
        echo "Token not found or expired";
        exit;
    }

    // simpan cache baru
    file_put_contents($cacheFile, json_encode($row));
}

$origin = $row['origin_url'];
$exp = strtotime($row['expires_at']);
$now = time();

//  Auto-refresh token bila kedaluwarsa
if ($exp <= $now) {
    $newHash = ensure_hash_for_url($origin, $row['user_id'], $row['playlist_name']);
    header("Location: {$GLOBALS['vipBase']}/t/$newHash", true, 302);
    exit;
}

//  Jika sisa waktu < 5 menit, refresh halus
if (($exp - $now) < 300) {
    $newHash = ensure_hash_for_url($origin, $row['user_id'], $row['playlist_name']);
    header("Refresh: 0; url={$GLOBALS['vipBase']}/t/$newHash");
}

//  Redirect cepat ke URL asli (ringan & stabil)
header("Location: $origin", true, 302);
exit;
