CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  flag ENUM('start','sukses','gagal','expiredate') NOT NULL DEFAULT 'start',
  logses INT NOT NULL DEFAULT 0,
  username VARCHAR(10) NOT NULL UNIQUE,
  expiredate DATE NOT NULL,
  playlist VARCHAR(100) NOT NULL,
  device_limit INT NOT NULL DEFAULT 1,
  password_hash VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS devices (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  device_id VARCHAR(128) NULL,
  mac_address VARCHAR(64) NULL,
  user_agent TEXT NULL,
  ip_address VARCHAR(64) NULL,
  first_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_user_device (user_id, device_id),
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS blocks (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  device_id VARCHAR(128) NULL,
  mac_address VARCHAR(64) NULL,
  ip_address VARCHAR(64) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS playlists (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL UNIQUE,
  info TEXT NULL,
  filename VARCHAR(150) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS token_map (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  hash_code CHAR(40) NOT NULL UNIQUE,
  origin_url TEXT NOT NULL,
  user_id INT NULL,
  playlist_name VARCHAR(100) NULL,
  issued_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  expires_at TIMESTAMP NOT NULL,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS error_logs (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  event_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  info TEXT NOT NULL,
  username VARCHAR(10) NULL,
  ip_address VARCHAR(64) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS admin_users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  admin_username VARCHAR(50) NOT NULL UNIQUE,
  admin_password_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT IGNORE INTO admin_users (admin_username, admin_password_hash)
VALUES ('admin', SHA2('admin123', 256));

DELIMITER $$
CREATE EVENT IF NOT EXISTS ev_purge_error_logs
ON SCHEDULE EVERY 7 DAY
DO
  DELETE FROM error_logs WHERE event_time < (NOW() - INTERVAL 7 DAY) $$
DELIMITER ;